/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.util;

import de.willuhn.logging.Logger;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;

public class Session
extends Observable {
    private static Worker worker = null;
    private long timeout;
    private Hashtable data = new Hashtable();

    private static final synchronized Worker getWorker() {
        if (worker != null) {
            return worker;
        }
        worker = new Worker();
        worker.start();
        return worker;
    }

    public Session() {
        this(1800000L);
    }

    public Session(long timeout) {
        Logger.debug("creating new session. default timeout: " + timeout + " millis");
        this.timeout = timeout;
        Session.getWorker().register(this);
    }

    public Enumeration keys() {
        return this.data.keys();
    }

    public void put(Object key, Object value) {
        this.put(key, value, this.timeout);
    }

    public void put(Object key, Object value, long t) {
        this.data.put(key, new SessionObject(value, t, false));
    }

    public void put(Object key, Object value, Date t) {
        this.data.put(key, new SessionObject(value, t.getTime(), true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        Hashtable hashtable = this.data;
        synchronized (hashtable) {
            SessionObject o = (SessionObject)this.data.get(key);
            return o == null ? null : o.getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        Hashtable hashtable = this.data;
        synchronized (hashtable) {
            SessionObject o = (SessionObject)this.data.remove(key);
            return o == null ? null : o.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Hashtable hashtable = this.data;
        synchronized (hashtable) {
            this.data.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Hashtable hashtable = this.data;
        synchronized (hashtable) {
            return this.data.size();
        }
    }

    protected void finalize() throws Throwable {
        Session.getWorker().unregister(this);
        super.finalize();
    }

    static /* synthetic */ long access$500(Session x0) {
        return x0.timeout;
    }

    private static final class Worker
    extends Thread {
        private ArrayList sessions = new ArrayList();

        public Worker() {
            super("Session Worker Thread");
            Logger.debug("Starting Session Worker Thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void register(Session session) {
            ArrayList arrayList = this.sessions;
            synchronized (arrayList) {
                if (!this.sessions.contains(session)) {
                    this.sessions.add(session);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unregister(Session session) {
            ArrayList arrayList = this.sessions;
            synchronized (arrayList) {
                this.sessions.remove(session);
                if (this.sessions.size() == 0) {
                    try {
                        Logger.debug("session worker thread no longer needed, shutting down");
                        this.interrupt();
                    }
                    catch (Exception e) {
                        Logger.error("unable to shut down worker thread", e);
                    }
                    finally {
                        worker = null;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!this.isInterrupted()) {
                    long current = System.currentTimeMillis();
                    ArrayList arrayList = this.sessions;
                    synchronized (arrayList) {
                        for (int i = 0; i < this.sessions.size(); ++i) {
                            Hashtable data;
                            Session s = (Session)this.sessions.get(i);
                            Hashtable hashtable = data = s.data;
                            synchronized (hashtable) {
                                Enumeration e = data.keys();
                                while (e.hasMoreElements()) {
                                    Object key = e.nextElement();
                                    SessionObject value = (SessionObject)data.get(key);
                                    if (current <= value.timestamp + value.myTimeout) continue;
                                    Logger.trace("removing object " + key + " from session");
                                    data.remove(key);
                                    s.setChanged();
                                    s.notifyObservers(value.value);
                                }
                                continue;
                            }
                        }
                    }
                    Worker.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
                Logger.debug("session worker thread interrupted");
            }
        }
    }

    private class SessionObject {
        private Object value;
        private long timestamp = System.currentTimeMillis();
        private long myTimeout = Session.access$500(Session.this);
        private boolean hardTimeout = false;

        private SessionObject(Object value, long t, boolean hardTimeout) {
            this.value = value;
            this.hardTimeout = hardTimeout;
            if (this.hardTimeout) {
                Logger.trace("added object \"" + value + "\" to session. hard timeout: " + new Date(t).toString());
                this.timestamp = t;
                this.myTimeout = 0L;
            } else {
                this.myTimeout = t;
                Logger.trace("added object \"" + value + "\" to session. timeout: " + t + " millis");
            }
        }

        private Object getValue() {
            if (!this.hardTimeout) {
                this.timestamp = System.currentTimeMillis();
            }
            return this.value;
        }
    }
}

